/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.serialize;

import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.impl.MicroDocumentType;
import com.phloc.commons.string.StringHelper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

final class MicroSAXHandler
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroSAXHandler.class);
    private IMicroDocument m_aDoc;
    private IMicroDocumentType m_aDocType;
    private IMicroNode m_aParent;
    private boolean m_bDTDMode = false;
    private boolean m_bCDATAMode = false;
    private final boolean m_bSaveIgnorableWhitespaces;
    private final EntityResolver m_aEntityResolver;

    MicroSAXHandler(boolean bSaveIgnorableWhitespaces, @Nullable EntityResolver aEntityResolver) {
        this.m_bSaveIgnorableWhitespaces = bSaveIgnorableWhitespaces;
        this.m_aEntityResolver = aEntityResolver;
    }

    private void _createParentDocument() {
        if (this.m_aParent == null) {
            this.m_aDoc = new MicroDocument(this.m_aDocType);
            this.m_aParent = this.m_aDoc;
        }
    }

    @Override
    public void setDocumentLocator(Locator aLocator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startDTD(String sName, String sPublicId, String sSystemId) throws SAXException {
        if (this.m_aDocType == null) {
            this.m_aDocType = new MicroDocumentType(sName, sPublicId, sSystemId);
        } else {
            s_aLogger.warn("DocType already present!");
        }
        this.m_bDTDMode = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.m_bDTDMode = false;
    }

    @Override
    public void startElement(@Nullable String sURI, @Nonnull String sLocalName, @Nullable String sQName, @Nullable Attributes aAttributes) {
        this._createParentDocument();
        IMicroElement aElement = StringHelper.hasText(sURI) ? this.m_aParent.appendElement(sURI, sLocalName) : this.m_aParent.appendElement(sLocalName);
        if (aAttributes != null) {
            int nAttrCount = aAttributes.getLength();
            for (int i = 0; i < nAttrCount; ++i) {
                aElement.setAttribute(aAttributes.getQName(i), aAttributes.getValue(i));
            }
        }
        this.m_aParent = aElement;
    }

    @Override
    public void endElement(String sURI, String sLocalName, String sQName) {
        this.m_aParent = this.m_aParent.getParent();
    }

    @Override
    public void characters(char[] aChars, int nStart, int nLength) {
        String sText = new String(aChars, nStart, nLength);
        if (this.m_bCDATAMode) {
            this.m_aParent.appendCDATA(sText);
        } else {
            IMicroNode aLastChild = this.m_aParent.getLastChild();
            if (aLastChild instanceof IMicroText && !((IMicroText)aLastChild).isElementContentWhitespace()) {
                ((IMicroText)aLastChild).appendData(sText);
            } else {
                this.m_aParent.appendText(sText);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] aChars, int nStart, int nLength) {
        if (this.m_bSaveIgnorableWhitespaces) {
            String sText = new String(aChars, nStart, nLength);
            IMicroNode aLastChild = this.m_aParent.getLastChild();
            if (aLastChild instanceof IMicroText && ((IMicroText)aLastChild).isElementContentWhitespace()) {
                ((IMicroText)aLastChild).appendData(sText);
            } else {
                this.m_aParent.appendIgnorableWhitespaceText(sText);
            }
        }
    }

    @Override
    public void processingInstruction(String sTarget, String sData) {
        this._createParentDocument();
        this.m_aParent.appendProcessingInstruction(sTarget, sData);
    }

    @Override
    @Nullable
    public InputSource resolveEntity(String sPublicId, String sSystemId) throws IOException, SAXException {
        if (this.m_aEntityResolver != null) {
            return this.m_aEntityResolver.resolveEntity(sPublicId, sSystemId);
        }
        s_aLogger.warn("Resolve entity '" + sPublicId + "' from '" + sSystemId + "'");
        return null;
    }

    @Override
    public void unparsedEntityDecl(String sName, String sPublicId, String sSystemId, String sNotationName) {
        s_aLogger.warn("Unparsed entity decl: " + sName + "--" + sPublicId + "--" + sSystemId + "--" + sNotationName);
    }

    @Override
    public void notationDecl(String sName, String sPublicId, String sSystemId) throws SAXException {
        s_aLogger.warn("Unparsed notation decl: " + sName + "--" + sPublicId + "--" + sSystemId);
    }

    @Override
    public void skippedEntity(String sName) {
        s_aLogger.warn("Skipped entity: " + sName);
    }

    @Override
    public void startPrefixMapping(String sPrefix, String sURI) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String sPrefix) throws SAXException {
    }

    private static String _getMsg(SAXParseException ex) {
        return "[SAX] [" + ex.getLineNumber() + ":" + ex.getColumnNumber() + "] " + ex.getMessage();
    }

    @Override
    public void warning(SAXParseException ex) {
        s_aLogger.warn(MicroSAXHandler._getMsg(ex));
    }

    @Override
    public void error(SAXParseException ex) {
        s_aLogger.error(MicroSAXHandler._getMsg(ex));
    }

    @Override
    public void fatalError(SAXParseException ex) {
        s_aLogger.error(MicroSAXHandler._getMsg(ex));
    }

    @Override
    public void startEntity(String sName) throws SAXException {
    }

    @Override
    public void endEntity(String sName) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_bCDATAMode = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_bCDATAMode = false;
    }

    @Override
    public void comment(char[] aChars, int nStart, int nLength) throws SAXException {
        if (!this.m_bDTDMode) {
            this._createParentDocument();
            String sComment = new String(aChars, nStart, nLength);
            this.m_aParent.appendComment(sComment);
        }
    }

    @Nullable
    public IMicroDocument getDocument() {
        return this.m_aDoc;
    }
}

