/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.reader;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.microdom.serialize.MicroWriter;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLMapHandler {
    public static final String ELEMENT_MAPPING = "mapping";
    public static final String ELEMENT_MAP = "map";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLMapHandler.class);
    private static final XMLMapHandler s_aInstance = new XMLMapHandler();

    private XMLMapHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static Map<String, String> readMap(@Nonnull IInputStreamProvider aISP) {
        if (aISP == null) {
            throw new NullPointerException("ISP");
        }
        return XMLMapHandler.readMap(aISP.getInputStream());
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IInputStreamProvider aISP, @Nonnull Map<String, String> aTargetMap) {
        if (aISP == null) {
            throw new NullPointerException("ISP");
        }
        return XMLMapHandler.readMap(aISP.getInputStream(), aTargetMap);
    }

    @Nullable
    @ReturnsMutableCopy
    public static Map<String, String> readMap(@Nonnull @WillClose InputStream aIS) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (XMLMapHandler.readMap(aIS, ret).isFailure()) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readMap(@Nonnull @WillClose InputStream aIS, @Nonnull Map<String, String> aTargetMap) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (aTargetMap == null) {
            throw new NullPointerException("targetMap");
        }
        try {
            IMicroDocument aDoc = MicroReader.readMicroXML(aIS);
            if (aDoc != null) {
                XMLMapHandler.readMap(aDoc.getDocumentElement(), aTargetMap);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Throwable t) {
            s_aLogger.warn("Failed to read mapping resource '" + aIS + "'", t);
        }
        finally {
            StreamUtils.close(aIS);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IMicroElement aParentElement, @Nonnull Map<String, String> aTargetMap) {
        if (aParentElement == null) {
            throw new NullPointerException("parentElement");
        }
        if (aTargetMap == null) {
            throw new NullPointerException("targetMap");
        }
        try {
            for (IMicroElement eMap : aParentElement.getChildElements(ELEMENT_MAP)) {
                String sName = eMap.getAttribute(ATTR_KEY);
                if (sName == null) {
                    s_aLogger.warn("Ignoring mapping element because key is null");
                    continue;
                }
                String sValue = eMap.getAttribute(ATTR_VALUE);
                if (sValue == null) {
                    s_aLogger.warn("Ignoring mapping element because value is null");
                    continue;
                }
                if (aTargetMap.containsKey(sName)) {
                    s_aLogger.warn("Key '" + sName + "' is already contained - overwriting!");
                }
                aTargetMap.put(sName, sValue);
            }
            return ESuccess.SUCCESS;
        }
        catch (Throwable t) {
            s_aLogger.warn("Failed to read mapping document", t);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createMapDocument(@Nonnull Map<String, String> aMap) {
        if (aMap == null) {
            throw new NullPointerException(ELEMENT_MAP);
        }
        MicroDocument aDoc = new MicroDocument();
        IMicroElement eRoot = aDoc.appendElement(ELEMENT_MAPPING);
        for (Map.Entry<String, String> aEntry : aMap.entrySet()) {
            IMicroElement eMap = eRoot.appendElement(ELEMENT_MAP);
            eMap.setAttribute(ATTR_KEY, aEntry.getKey());
            eMap.setAttribute(ATTR_VALUE, aEntry.getValue());
        }
        return aDoc;
    }

    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> aMap, @Nonnull IOutputStreamProvider aOSP) {
        if (aOSP == null) {
            throw new NullPointerException("outputStreamProvider");
        }
        return XMLMapHandler.writeMap(aMap, aOSP.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> aMap, @Nonnull @WillClose OutputStream aOS) {
        if (aMap == null) {
            throw new NullPointerException(ELEMENT_MAP);
        }
        if (aOS == null) {
            throw new NullPointerException("outputStream");
        }
        try {
            IMicroDocument aDoc = XMLMapHandler.createMapDocument(aMap);
            ESuccess eSuccess = MicroWriter.writeToStream(aDoc, aOS, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }
}

