/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.microdom.EMicroEvent;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

abstract class AbstractMicroNodeWithChildren
extends AbstractMicroNode {
    private List<IMicroNode> m_aChildren;

    AbstractMicroNodeWithChildren() {
    }

    @Nullable
    @ReturnsMutableObject(reason="efficient access")
    final List<IMicroNode> directGetChildren() {
        return this.m_aChildren;
    }

    private void _afterInsertAsChildOfThis(@Nonnull AbstractMicroNode aChildNode) {
        aChildNode.setParentNode(this);
        this.onEvent(EMicroEvent.NODE_INSERTED, this, aChildNode);
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode aChildNode) {
        if (aChildNode.isDocument()) {
            throw new MicroException("Cannot add document to documents");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<IMicroNode>();
        }
        this.m_aChildren.add(aChildNode);
        this._afterInsertAsChildOfThis(aChildNode);
    }

    @Override
    protected final void onInsertBefore(@Nonnull AbstractMicroNode aChildNode, @Nonnull IMicroNode aSuccessor) {
        if (aChildNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (aSuccessor == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        int nIndex = this.m_aChildren.lastIndexOf(aSuccessor);
        if (nIndex == -1) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        this.m_aChildren.add(nIndex, aChildNode);
        this._afterInsertAsChildOfThis(aChildNode);
    }

    @Override
    protected final void onInsertAfter(@Nonnull AbstractMicroNode aChildNode, @Nonnull IMicroNode aPredecessor) {
        if (aChildNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (aPredecessor == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        int nIndex = this.m_aChildren.lastIndexOf(aPredecessor);
        if (nIndex == -1) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        this.m_aChildren.add(nIndex + 1, aChildNode);
        this._afterInsertAsChildOfThis(aChildNode);
    }

    @Override
    protected final void onInsertAtIndex(@Nonnegative int nIndex, @Nonnull AbstractMicroNode aChildNode) {
        if (nIndex < 0) {
            throw new MicroException("Cannot insert element at index " + nIndex + "!");
        }
        if (aChildNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<IMicroNode>();
        }
        this.m_aChildren.add(Math.min(nIndex, this.m_aChildren.size()), aChildNode);
        this._afterInsertAsChildOfThis(aChildNode);
    }

    private void _afterRemoveChildOfThis(@Nonnull IMicroNode aChildNode) {
        if (this.m_aChildren.contains(aChildNode)) {
            throw new IllegalStateException("Child " + aChildNode + " is contained more than once in it's parents list");
        }
        if (this.m_aChildren.isEmpty()) {
            this.m_aChildren = null;
        }
        ((AbstractMicroNode)aChildNode).resetParentNode();
        this.onEvent(EMicroEvent.NODE_REMOVED, this, aChildNode);
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChild(@Nonnull IMicroNode aChildNode) {
        if (!aChildNode.hasParent()) {
            throw new MicroException("The passed child node to be removed has no parent!");
        }
        if (this.m_aChildren == null || !this.m_aChildren.remove(aChildNode)) {
            return EChange.UNCHANGED;
        }
        this._afterRemoveChildOfThis(aChildNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChildAtIndex(@Nonnegative int nIndex) {
        IMicroNode aChildNode = this.getChildAtIndex(nIndex);
        if (aChildNode == null) {
            return EChange.UNCHANGED;
        }
        if (!aChildNode.hasParent()) {
            throw new MicroException("Internal inconsistency: the passed child node to be removed has no parent!");
        }
        if (this.m_aChildren.remove(nIndex) != aChildNode) {
            throw new MicroException("Internal inconsistency: remove resulted in an illegal object!");
        }
        this._afterRemoveChildOfThis(aChildNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveAllChildren() {
        if (this.m_aChildren == null || this.m_aChildren.isEmpty()) {
            return EChange.UNCHANGED;
        }
        while (this.hasChildren()) {
            this.removeChildAtIndex(0);
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && !this.m_aChildren.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<IMicroNode> getChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    public final IMicroNode getChildAtIndex(@Nonnegative int nIndex) {
        return ContainerHelper.getSafe(this.m_aChildren, nIndex);
    }

    @Override
    public final int getChildCount() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.size();
    }

    @Override
    @Nullable
    public final IMicroNode getFirstChild() {
        return this.hasChildren() ? this.m_aChildren.get(0) : null;
    }

    @Override
    @Nullable
    public final IMicroNode getLastChild() {
        int nChildCount = this.getChildCount();
        return nChildCount == 0 ? null : this.m_aChildren.get(nChildCount - 1);
    }

    private void _fillListPrefix(@Nonnull IMicroNode aCurNode, @Nonnull List<IMicroNode> aNodes) {
        if (aCurNode.hasChildren()) {
            for (IMicroNode aCurrent : aCurNode.getChildren()) {
                aNodes.add(aCurrent);
                this._fillListPrefix(aCurrent, aNodes);
            }
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<IMicroNode> getAllChildrenRecursive() {
        ArrayList<IMicroNode> ret = new ArrayList<IMicroNode>();
        this._fillListPrefix(this, ret);
        return ret;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEqualContent(@Nullable IMicroNode o) {
        int nMaxRhs;
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractMicroNodeWithChildren rhs = (AbstractMicroNodeWithChildren)o;
        if (this.m_aChildren == null && rhs.m_aChildren == null) {
            return true;
        }
        if (this.m_aChildren == null || rhs.m_aChildren == null) {
            return false;
        }
        int nMax = this.m_aChildren.size();
        if (nMax != (nMaxRhs = rhs.m_aChildren.size())) {
            return false;
        }
        for (int i = 0; i < nMax; ++i) {
            if (this.m_aChildren.get(i).isEqualContent(rhs.m_aChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("childrenCount", this.m_aChildren == null ? 0 : this.m_aChildren.size()).toString();
    }
}

