/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.io.streams.NonBlockingBufferedReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ServiceLoaderException;
import com.phloc.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderBackport<SPITYPE>
implements Iterable<SPITYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceLoaderBackport.class);
    private static final String PREFIX = "META-INF/services/";
    private final Class<SPITYPE> m_aService;
    private final ClassLoader m_aClassLoader;
    private final Map<String, SPITYPE> m_aProviders = new LinkedHashMap<String, SPITYPE>();
    private LazyIterator m_aLookupIterator;

    public void reload() {
        this.m_aProviders.clear();
        this.m_aLookupIterator = new LazyIterator(this.m_aService, this.m_aClassLoader);
    }

    private ServiceLoaderBackport(Class<SPITYPE> svc, ClassLoader cl) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Loading all SPI implementations of " + svc.toString());
        }
        this.m_aService = svc;
        this.m_aClassLoader = cl;
        this.reload();
    }

    private static void _fail(Class<?> service, String msg, Throwable cause) {
        throw new ServiceLoaderException(service.getName() + ": " + msg, cause);
    }

    private static void _fail(Class<?> service, String msg) {
        throw new ServiceLoaderException(service.getName() + ": " + msg);
    }

    private static void _fail(Class<?> service, URL u, int line, String msg) {
        throw new ServiceLoaderException(service.getName() + ": " + u + ":" + line + ": " + msg);
    }

    private int _parseLine(Class<SPITYPE> aService, URL u, NonBlockingBufferedReader r, int lc, List<String> names) throws IOException {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoaderBackport._fail(aService, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceLoaderBackport._fail(aService, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceLoaderBackport._fail(aService, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.m_aProviders.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> _parse(Class<SPITYPE> aService, URL u) {
        InputStream in = null;
        NonBlockingBufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new NonBlockingBufferedReader(StreamUtils.createReader(in, "UTF-8"));
            int lc = 1;
            while ((lc = this._parseLine(aService, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceLoaderBackport._fail(aService, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceLoaderBackport._fail(aService, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<SPITYPE> iterator() {
        return new Iterator<SPITYPE>(){
            private final Iterator<Map.Entry<String, SPITYPE>> m_aKnownProviders;
            {
                this.m_aKnownProviders = ServiceLoaderBackport.this.m_aProviders.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.m_aKnownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoaderBackport.this.m_aLookupIterator.hasNext();
            }

            @Override
            public SPITYPE next() {
                if (this.m_aKnownProviders.hasNext()) {
                    return this.m_aKnownProviders.next().getValue();
                }
                return ServiceLoaderBackport.this.m_aLookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return new ToStringGenerator(this).append("serviceName", this.m_aService.getName()).toString();
    }

    public static <S> ServiceLoaderBackport<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoaderBackport<S>(service, loader);
    }

    public static <S> ServiceLoaderBackport<S> load(Class<S> service) {
        return ServiceLoaderBackport.load(service, ClassHelper.getDefaultClassLoader());
    }

    public static <S> ServiceLoaderBackport<S> loadInstalled(Class<S> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ServiceLoaderBackport.load(service, prev);
    }

    @SuppressFBWarnings(value={"UWF_NULL_FIELD"})
    private final class LazyIterator
    implements Iterator<SPITYPE> {
        private final Class<SPITYPE> m_aLIService;
        private final ClassLoader m_aLILoader;
        private Enumeration<URL> m_aLIConfigs = null;
        private Iterator<String> m_aLIPending = null;
        private String m_sLINextName = null;

        public LazyIterator(Class<SPITYPE> aService, ClassLoader aLoader) {
            this.m_aLIService = aService;
            this.m_aLILoader = aLoader;
        }

        @Override
        public boolean hasNext() {
            if (this.m_sLINextName != null) {
                return true;
            }
            if (this.m_aLIConfigs == null) {
                try {
                    String fullName = ServiceLoaderBackport.PREFIX + this.m_aLIService.getName();
                    this.m_aLIConfigs = this.m_aLILoader == null ? ClassLoader.getSystemResources(fullName) : this.m_aLILoader.getResources(fullName);
                }
                catch (IOException ex) {
                    ServiceLoaderBackport._fail(this.m_aLIService, "Error locating configuration files", ex);
                }
            }
            while (this.m_aLIPending == null || !this.m_aLIPending.hasNext()) {
                if (!this.m_aLIConfigs.hasMoreElements()) {
                    return false;
                }
                this.m_aLIPending = ServiceLoaderBackport.this._parse(this.m_aLIService, this.m_aLIConfigs.nextElement());
            }
            this.m_sLINextName = this.m_aLIPending.next();
            return true;
        }

        @Override
        public SPITYPE next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String sClassName = this.m_sLINextName;
            this.m_sLINextName = null;
            try {
                Object p = this.m_aLIService.cast(Class.forName(sClassName, true, this.m_aLILoader).newInstance());
                ServiceLoaderBackport.this.m_aProviders.put(sClassName, p);
                return p;
            }
            catch (ClassNotFoundException x) {
                ServiceLoaderBackport._fail(this.m_aLIService, "Provider " + sClassName + " not found");
            }
            catch (Throwable x) {
                ServiceLoaderBackport._fail(this.m_aLIService, "Provider " + sClassName + " could not be instantiated: " + x, x);
            }
            throw new Error();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

