/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.collections.ArrayHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.meta.When;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class GenericReflection {
    private static final Logger s_aLogger = LoggerFactory.getLogger(GenericReflection.class);
    private static final GenericReflection s_aInstance = new GenericReflection();

    private GenericReflection() {
    }

    public static <SRCTYPE, DSTTYPE> DSTTYPE uncheckedCast(@Nullable SRCTYPE aObject) {
        return (DSTTYPE)aObject;
    }

    @Nonnull
    public static <DATATYPE> Class<DATATYPE> getClassFromName(@Nonnull String sName) throws ClassNotFoundException {
        return (Class)GenericReflection.uncheckedCast(Class.forName(sName));
    }

    @Nullable
    public static <DATATYPE> Class<DATATYPE> getClassFromNameSafe(@Nonnull String sName) {
        try {
            return GenericReflection.getClassFromName(sName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nonnull
    public static Class<?>[] getClassArray(Object ... aObjs) {
        if (ArrayHelper.isEmpty(aObjs)) {
            return new Class[0];
        }
        Class[] ret = new Class[aObjs.length];
        for (int i = 0; i < aObjs.length; ++i) {
            ret[i] = aObjs[i].getClass();
        }
        return ret;
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeMethod(@Nonnull Object aSrcObj, @Nonnull String sMethodName, Object ... aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeMethod(aSrcObj, sMethodName, GenericReflection.getClassArray(aArgs), aArgs);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeMethod(@Nonnull Object aSrcObj, @Nonnull String sMethodName, @Nullable Class<?>[] aArgClasses, @Nullable Object[] aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method aMethod = aSrcObj.getClass().getDeclaredMethod(sMethodName, aArgClasses);
        Object aReturn = aMethod.invoke(aSrcObj, aArgs);
        return (RETURNTYPE)GenericReflection.uncheckedCast(aReturn);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull String sClassName, @Nonnull String sMethodName, Object ... aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(sClassName), sMethodName, aArgs);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull Class<?> aClass, @Nonnull String sMethodName, Object ... aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeStaticMethod(aClass, sMethodName, GenericReflection.getClassArray(aArgs), aArgs);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull String sClassName, @Nonnull String sMethodName, @Nullable Class<?>[] aArgClasses, @Nullable Object[] aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(sClassName), sMethodName, aArgClasses, aArgs);
    }

    @Nullable
    public static <RETURNTYPE> RETURNTYPE invokeStaticMethod(@Nonnull Class<?> aClass, @Nonnull String sMethodName, @Nullable Class<?>[] aArgClasses, @Nullable Object[] aArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method aMethod = aClass.getDeclaredMethod(sMethodName, aArgClasses);
        Object aReturn = aMethod.invoke(null, aArgs);
        return (RETURNTYPE)GenericReflection.uncheckedCast(aReturn);
    }

    @Nonnull
    public static <DATATYPE> Constructor<DATATYPE> findConstructor(@Nonnull DATATYPE aObj, Class<?> ... aCtorArgs) throws NoSuchMethodException {
        return (Constructor)GenericReflection.uncheckedCast(aObj.getClass().getConstructor(aCtorArgs));
    }

    @Nonnull(when=When.MAYBE)
    public static <DATATYPE> DATATYPE newInstance(@Nonnull DATATYPE aObj) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        return GenericReflection.findConstructor(aObj, new Class[0]).newInstance(new Object[0]);
    }

    @Nonnull(when=When.MAYBE)
    public static <DATATYPE> DATATYPE newInstance(@Nullable Class<? extends DATATYPE> aClass) {
        if (aClass != null) {
            try {
                return aClass.newInstance();
            }
            catch (Throwable t) {
                s_aLogger.error("Failed to instantiate " + aClass, t);
            }
        }
        return null;
    }

    @Nonnull(when=When.MAYBE)
    public static <DATATYPE> DATATYPE newInstance(@Nullable String sClassName, @Nullable Class<DATATYPE> aDesiredType) {
        if (sClassName != null && aDesiredType != null) {
            try {
                return aDesiredType.cast(GenericReflection.getClassFromName(sClassName).newInstance());
            }
            catch (Throwable t) {
                s_aLogger.error("Failed to instantiate '" + sClassName + "'", t);
            }
        }
        return null;
    }

    @Nonnull(when=When.MAYBE)
    public static <DATATYPE> DATATYPE newInstance(@Nullable String sClassName, @Nullable Class<DATATYPE> aDesiredType, @Nullable ClassLoader aClassLoaderToUse) {
        if (sClassName != null && aDesiredType != null && aClassLoaderToUse != null) {
            try {
                return aDesiredType.cast(Class.forName(sClassName, true, aClassLoaderToUse).newInstance());
            }
            catch (Throwable t) {
                s_aLogger.error("Failed to instantiate '" + sClassName + "' with CL " + aClassLoaderToUse, t);
            }
        }
        return null;
    }
}

