/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLResource
implements IReadableResource {
    public static final String PROTOCOL_FILE = "file";
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLResource.class);
    private final URL m_aURL;

    public URLResource(@Nonnull String sURL) throws MalformedURLException {
        this(new URL(sURL));
    }

    public URLResource(@Nonnull URL aURL) {
        if (aURL == null) {
            throw new NullPointerException("URL");
        }
        this.m_aURL = aURL;
    }

    public static boolean isExplicitURLResource(@Nullable String sName) {
        if (StringHelper.hasText(sName)) {
            try {
                new URL(sName);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_aURL.toExternalForm();
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull URL aURL) {
        if (aURL == null) {
            throw new NullPointerException("URL");
        }
        try {
            URLConnection aConnection = aURL.openConnection();
            aConnection.setUseCaches(false);
            return aConnection.getInputStream();
        }
        catch (IOException ex) {
            s_aLogger.warn("Failed to open input stream for '" + aURL + "': " + ex.getClass().getName() + " - " + ex.getMessage());
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return URLResource.getInputStream(this.m_aURL);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull String sCharset) {
        return StreamUtils.createReader(this.getInputStream(), sCharset);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset aCharset) {
        return StreamUtils.createReader(this.getInputStream(), aCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if (PROTOCOL_FILE.equals(this.m_aURL.getProtocol())) {
            return this.getAsFile().exists();
        }
        InputStream aIS = null;
        try {
            aIS = this.getInputStream();
            boolean bl = aIS != null;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.close(aIS);
        }
    }

    @Override
    @Nonnull
    public URL getAsURL() {
        return this.m_aURL;
    }

    @Nonnull
    public static File getAsFile(@Nonnull URL aURL) {
        File aFile;
        if (aURL == null) {
            throw new NullPointerException("URL");
        }
        if (!PROTOCOL_FILE.equals(aURL.getProtocol())) {
            throw new IllegalArgumentException("Not a file URL: " + aURL);
        }
        try {
            aFile = new File(aURL.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            aFile = new File(aURL.getPath());
        }
        return aFile;
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return URLResource.getAsFile(this.m_aURL);
    }

    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull URL aURL) {
        return new URLResource(aURL);
    }

    @Override
    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull String sPath) {
        try {
            return new URLResource(sPath);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Cannot convert to an URL: " + sPath, ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLResource)) {
            return false;
        }
        URLResource rhs = (URLResource)o;
        return EqualsUtils.equals(this.m_aURL, rhs.m_aURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("url", this.m_aURL).toString();
    }
}

