/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterPublicDirectory
implements FilenameFilter {
    private static final FilenameFilterPublicDirectory s_aInstance = new FilenameFilterPublicDirectory();

    private FilenameFilterPublicDirectory() {
    }

    @Override
    public boolean accept(@Nonnull File aDir, @Nonnull String sName) {
        String sRealName = FilenameHelper.getSecureFilename(sName);
        return new File(aDir, sRealName).isDirectory() && !StringHelper.startsWith((CharSequence)sRealName, '.');
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }

    @Nonnull
    public static FilenameFilterPublicDirectory getInstance() {
        return s_aInstance;
    }
}

