/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterEquals
implements FilenameFilter {
    private final String m_sFilename;

    public FilenameFilterEquals(@Nonnull @Nonempty String sFilename) {
        if (StringHelper.hasNoText(sFilename)) {
            throw new IllegalArgumentException("filename");
        }
        this.m_sFilename = sFilename;
    }

    @Override
    public boolean accept(@Nullable File aDir, @Nullable String sName) {
        String sRealName = FilenameHelper.getSecureFilename(sName);
        return sRealName != null && sRealName.equals(this.m_sFilename);
    }

    public String toString() {
        return new ToStringGenerator(this).append("filename", this.m_sFilename).toString();
    }
}

