/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.file.EFileIOErrorCode;
import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileOperations {
    public static final boolean DEFAULT_WARN_ON_DELETE_ROOT = true;
    private static final FileOperations s_aInstance = new FileOperations();
    private static boolean s_bWarnOnDeleteRoot = true;

    private FileOperations() {
    }

    public static boolean isWarnOnDeleteRoot() {
        return s_bWarnOnDeleteRoot;
    }

    public static void setWarnOnDeleteRoot(boolean bWarnOnDeleteRoot) {
        s_bWarnOnDeleteRoot = bWarnOnDeleteRoot;
    }

    @Nonnull
    public static FileIOError createDir(@Nonnull File aDir) {
        if (aDir == null) {
            throw new NullPointerException("directory");
        }
        if (aDir.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR, aDir);
        }
        File aParentDir = aDir.getParentFile();
        if (aParentDir != null && aParentDir.exists() && !FileUtils.canWrite(aParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR, aDir);
        }
        try {
            EFileIOErrorCode eError = aDir.mkdir() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.CREATE_DIR, aDir);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR, ex);
        }
    }

    @Nonnull
    public static FileIOError createDirIfNotExisting(@Nonnull File aDir) {
        FileIOError aError = FileOperations.createDir(aDir);
        if (aError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR, aDir);
        }
        return aError;
    }

    @Nonnull
    public static FileIOError createDirRecursive(@Nonnull File aDir) {
        if (aDir == null) {
            throw new NullPointerException("directory");
        }
        if (aDir.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, aDir);
        }
        File aParentDir = aDir.getParentFile();
        if (aParentDir != null && aParentDir.exists() && !FileUtils.canWrite(aParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, aDir);
        }
        try {
            EFileIOErrorCode eError = aDir.mkdirs() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, aDir);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, ex);
        }
    }

    @Nonnull
    public static FileIOError createDirRecursiveIfNotExisting(@Nonnull File aDir) {
        FileIOError aError = FileOperations.createDirRecursive(aDir);
        if (aError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, aDir);
        }
        return aError;
    }

    @Nonnull
    public static FileIOError deleteDir(@Nonnull File aDir) {
        if (aDir == null) {
            throw new NullPointerException("directory");
        }
        if (!FileUtils.existsDir(aDir)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR, aDir);
        }
        if (FileOperations.isWarnOnDeleteRoot() && aDir.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + aDir.getAbsolutePath() + "'");
        }
        File aParentDir = aDir.getParentFile();
        if (aParentDir != null && !FileUtils.canWrite(aParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR, aDir);
        }
        try {
            EFileIOErrorCode eError = aDir.delete() && !aDir.exists() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.DELETE_DIR, aDir);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_DIR, ex);
        }
    }

    @Nonnull
    public static FileIOError deleteDirIfExisting(@Nonnull File aDir) {
        FileIOError aError = FileOperations.deleteDir(aDir);
        if (aError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR, aDir);
        }
        return aError;
    }

    @Nonnull
    public static FileIOError deleteDirRecursive(@Nonnull File aDir) {
        if (aDir == null) {
            throw new NullPointerException("directory");
        }
        if (!FileUtils.existsDir(aDir)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, aDir);
        }
        if (FileOperations.isWarnOnDeleteRoot() && aDir.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + aDir.getAbsolutePath() + "'");
        }
        File aParentDir = aDir.getParentFile();
        if (aParentDir != null && !FileUtils.canWrite(aParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, aDir);
        }
        for (File aChild : FileUtils.getDirectoryContent(aDir)) {
            FileIOError eCode;
            if (aChild.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(aChild.getName()) || !(eCode = FileOperations.deleteDirRecursive(aChild)).isFailure()) continue;
                return eCode;
            }
            if (aChild.isFile()) {
                eCode = FileOperations.deleteFile(aChild);
                if (!eCode.isFailure()) continue;
                return eCode;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, aChild);
        }
        return FileOperations.deleteDir(aDir);
    }

    @Nonnull
    public static FileIOError deleteDirRecursiveIfExisting(@Nonnull File aDir) {
        FileIOError aError = FileOperations.deleteDirRecursive(aDir);
        if (aError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, aDir);
        }
        return aError;
    }

    @Nonnull
    public static FileIOError deleteFile(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (!FileUtils.existsFile(aFile)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_FILE, aFile);
        }
        File aParentDir = aFile.getParentFile();
        if (aParentDir != null && !FileUtils.canWrite(aParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_FILE, aFile);
        }
        try {
            EFileIOErrorCode eError = aFile.delete() && !aFile.exists() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.DELETE_FILE, aFile);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_FILE, ex);
        }
    }

    @Nonnull
    public static FileIOError deleteFileIfExisting(@Nonnull File aFile) {
        FileIOError aError = FileOperations.deleteFile(aFile);
        if (aError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_FILE, aFile);
        }
        return aError;
    }

    @Nonnull
    public static FileIOError renameFile(@Nonnull File aSourceFile, @Nonnull File aTargetFile) {
        if (aSourceFile == null) {
            throw new NullPointerException("sourceFile");
        }
        if (aTargetFile == null) {
            throw new NullPointerException("targetFile");
        }
        if (!FileUtils.existsFile(aSourceFile)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_FILE, aSourceFile);
        }
        if (FileUtils.safeEquals(aSourceFile, aTargetFile)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_FILE, aSourceFile);
        }
        if (aTargetFile.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_FILE, aTargetFile);
        }
        File aSourceParentDir = aSourceFile.getParentFile();
        if (aSourceParentDir != null && !FileUtils.canWrite(aSourceParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, aSourceFile);
        }
        File aTargetParentDir = aTargetFile.getParentFile();
        if (aTargetParentDir != null && aTargetParentDir.exists() && !FileUtils.canWrite(aTargetParentDir)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, aTargetFile);
        }
        FileUtils.ensureParentDirectoryIsPresent(aTargetFile);
        try {
            EFileIOErrorCode eError = aSourceFile.renameTo(aTargetFile) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.RENAME_FILE, aSourceFile, aTargetFile);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_FILE, ex);
        }
    }

    @Nonnull
    public static FileIOError renameDir(@Nonnull File aSourceDir, @Nonnull File aTargetDir) {
        if (aSourceDir == null) {
            throw new NullPointerException("sourceDirectory");
        }
        if (aTargetDir == null) {
            throw new NullPointerException("targetDirectory");
        }
        if (!FileUtils.existsDir(aSourceDir)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_DIR, aSourceDir);
        }
        if (FileUtils.safeEquals(aSourceDir, aTargetDir)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_DIR, aSourceDir);
        }
        if (aTargetDir.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_DIR, aTargetDir);
        }
        if (FileUtils.isParentDirectory(aSourceDir, aTargetDir)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.RENAME_DIR, aSourceDir, aTargetDir);
        }
        File aSourceParentDir = aSourceDir.getParentFile();
        if (aSourceParentDir != null && !FileUtils.canWrite(aSourceParentDir)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, aSourceDir);
        }
        File aTargetParentDir = aTargetDir.getParentFile();
        if (aTargetParentDir != null && aTargetParentDir.exists() && !FileUtils.canWrite(aTargetParentDir)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, aTargetDir);
        }
        FileUtils.ensureParentDirectoryIsPresent(aTargetDir);
        try {
            EFileIOErrorCode eError = aSourceDir.renameTo(aTargetDir) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eError.getAsIOError(EFileIOOperation.RENAME_DIR, aSourceDir, aTargetDir);
        }
        catch (SecurityException ex) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_DIR, ex);
        }
    }

    @Nonnull
    public static FileIOError copyFile(@Nonnull File aSourceFile, @Nonnull File aTargetFile) {
        if (aSourceFile == null) {
            throw new NullPointerException("sourceFile");
        }
        if (aTargetFile == null) {
            throw new NullPointerException("targetFile");
        }
        if (!FileUtils.existsFile(aSourceFile)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_FILE, aSourceFile);
        }
        if (FileUtils.safeEquals(aSourceFile, aTargetFile)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_FILE, aSourceFile);
        }
        if (aTargetFile.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_FILE, aTargetFile);
        }
        if (!FileUtils.canRead(aSourceFile)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_FILE, aSourceFile);
        }
        File aTargetParentDir = aTargetFile.getParentFile();
        if (aTargetParentDir != null && aTargetParentDir.exists() && !FileUtils.canWrite(aTargetParentDir)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_FILE, aTargetFile);
        }
        FileUtils.ensureParentDirectoryIsPresent(aTargetFile);
        BufferedInputStream aIS = new BufferedInputStream(FileUtils.getInputStream(aSourceFile));
        BufferedOutputStream aOS = new BufferedOutputStream(FileUtils.getOutputStream(aTargetFile, EAppend.TRUNCATE));
        EFileIOErrorCode eError = StreamUtils.copyInputStreamToOutputStreamAndCloseOS(aIS, aOS).isSuccess() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
        return eError.getAsIOError(EFileIOOperation.COPY_FILE, aSourceFile, aTargetFile);
    }

    @Nonnull
    public static FileIOError copyDirRecursive(@Nonnull File aSourceDir, @Nonnull File aTargetDir) {
        if (aSourceDir == null) {
            throw new NullPointerException("sourceDirectory");
        }
        if (aTargetDir == null) {
            throw new NullPointerException("targetDirectory");
        }
        if (!FileUtils.existsDir(aSourceDir)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aSourceDir);
        }
        if (FileUtils.safeEquals(aSourceDir, aTargetDir)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aSourceDir);
        }
        if (FileUtils.isParentDirectory(aSourceDir, aTargetDir)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aSourceDir, aTargetDir);
        }
        if (aTargetDir.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aTargetDir);
        }
        if (!FileUtils.canRead(aSourceDir)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aSourceDir);
        }
        File aTargetParentDir = aTargetDir.getParentFile();
        if (aTargetParentDir != null && aTargetParentDir.exists() && !FileUtils.canWrite(aTargetParentDir)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aTargetDir);
        }
        FileIOError eCode = FileOperations.createDirRecursive(aTargetDir);
        if (eCode.isFailure()) {
            return eCode;
        }
        for (File aChild : FileUtils.getDirectoryContent(aSourceDir)) {
            if (aChild.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(aChild.getName()) || !(eCode = FileOperations.copyDirRecursive(aChild, new File(aTargetDir, aChild.getName()))).isFailure()) continue;
                return eCode;
            }
            if (aChild.isFile()) {
                eCode = FileOperations.copyFile(aChild, new File(aTargetDir, aChild.getName()));
                if (!eCode.isFailure()) continue;
                return eCode;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aChild);
        }
        return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, aSourceDir, aTargetDir);
    }
}

