/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.annotations.UseDirectEqualsAndHashCode;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.hash.IHashCodeImplementation;
import com.phloc.commons.hash.IHashCodeImplementationRegistrarSPI;
import com.phloc.commons.hash.IHashCodeImplementationRegistry;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HashCodeImplementationRegistry
implements IHashCodeImplementationRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(HashCodeImplementationRegistry.class);
    private static final HashCodeImplementationRegistry s_aInstance = new HashCodeImplementationRegistry();
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, IHashCodeImplementation> m_aMap = new WeakHashMap();
    private final Map<String, Boolean> m_aDirectHashCode = new HashMap<String, Boolean>();
    private final Map<String, Boolean> m_aImplementsHashCode = new HashMap<String, Boolean>();

    private HashCodeImplementationRegistry() {
        for (IHashCodeImplementationRegistrarSPI aRegistrar : ServiceLoaderBackport.load(IHashCodeImplementationRegistrarSPI.class)) {
            aRegistrar.registerHashCodeImplementations(this);
        }
    }

    @Nonnull
    public static HashCodeImplementationRegistry getInstance() {
        return s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHashCodeImplementation(@Nonnull Class<?> aClass, @Nonnull IHashCodeImplementation aImpl) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (aImpl == null) {
            throw new NullPointerException("implementation");
        }
        if (aClass.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide a hashCode implementation for Object.class!");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.containsKey(aClass)) {
                s_aLogger.warn("Another hashCode implementation for class " + aClass + " is already registered!");
            } else {
                this.m_aMap.put(aClass, aImpl);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange unregisterHashCodeImplementation(@Nonnull Class<?> aClass) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMap.remove(aClass) != null);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isUseDirectHashCode(@Nonnull Class<?> aClass) {
        Boolean aSavedState;
        String sClassName = aClass.getName();
        this.m_aRWLock.readLock().lock();
        try {
            aSavedState = this.m_aDirectHashCode.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            aSavedState = this.m_aDirectHashCode.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
            boolean bHasAnnotation = aClass.getAnnotation(UseDirectEqualsAndHashCode.class) != null;
            this.m_aDirectHashCode.put(sClassName, bHasAnnotation);
            boolean bl = bHasAnnotation;
            return bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _implementsHashCodeItself(@Nonnull Class<?> aClass) {
        Boolean aSavedState;
        String sClassName = aClass.getName();
        this.m_aRWLock.readLock().lock();
        try {
            aSavedState = this.m_aImplementsHashCode.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            aSavedState = this.m_aImplementsHashCode.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
            boolean bRet = false;
            try {
                Method aMethod = aClass.getDeclaredMethod("hashCode", new Class[0]);
                if (aMethod != null && aMethod.getReturnType().equals(Integer.TYPE)) {
                    bRet = true;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            this.m_aImplementsHashCode.put(sClassName, bRet);
            boolean bl = bRet;
            return bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IHashCodeImplementation getBestMatchingHashCodeImplementation(@Nullable Class<?> aClass) {
        if (aClass != null) {
            Class aMatchingClass;
            IHashCodeImplementation aMatchingImplementation;
            block19: {
                aMatchingImplementation = null;
                aMatchingClass = null;
                if (this._isUseDirectHashCode(aClass)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    aMatchingImplementation = this.m_aMap.get(aClass);
                    if (aMatchingImplementation != null) {
                        aMatchingClass = aClass;
                        break block19;
                    }
                    for (WeakReference<Class<?>> aCurWRClass : ClassHierarchyCache.getClassHierarchyIterator(aClass)) {
                        IHashCodeImplementation aImpl;
                        Class aCurClass = (Class)aCurWRClass.get();
                        if (aCurClass == null || (aImpl = this.m_aMap.get(aCurClass)) == null) continue;
                        aMatchingImplementation = aImpl;
                        aMatchingClass = aCurClass;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Found hierarchical match with class " + aMatchingClass + " when searching for " + aClass);
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (aMatchingImplementation != null) {
                if (ClassHelper.isInterface(aMatchingClass) && this._implementsHashCodeItself(aClass)) {
                    this.m_aRWLock.writeLock().lock();
                    try {
                        this.m_aDirectHashCode.put(aClass.getName(), Boolean.TRUE);
                    }
                    finally {
                        this.m_aRWLock.writeLock().unlock();
                    }
                    return null;
                }
                if (!aMatchingClass.equals(aClass)) {
                    this.registerHashCodeImplementation(aClass, aMatchingImplementation);
                }
                return aMatchingImplementation;
            }
            if (ClassHelper.isArrayClass(aClass)) {
                return new ArrayHashCodeImplementation();
            }
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aDirectHashCode.put(aClass.getName(), Boolean.TRUE);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Found no hashCode implementation for " + aClass);
        }
        return null;
    }

    public static int getHashCode(@Nullable Object aObj) {
        if (aObj == null) {
            return 129;
        }
        Class<?> aClass = aObj.getClass();
        IHashCodeImplementation aImpl = s_aInstance.getBestMatchingHashCodeImplementation(aClass);
        return aImpl == null ? aObj.hashCode() : aImpl.getHashCode(aObj);
    }

    private static final class ArrayHashCodeImplementation
    implements IHashCodeImplementation {
        @Override
        public int getHashCode(Object aObj) {
            Object[] aArray = (Object[])aObj;
            int nLength = aArray.length;
            HashCodeGenerator aHC = new HashCodeGenerator(aObj).append(nLength);
            for (int i = 0; i < nLength; ++i) {
                aHC = aHC.append(aArray[i]);
            }
            return aHC.getHashCode();
        }
    }
}

