/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.equals.EqualsImplementationRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EqualsUtils {
    private static final EqualsUtils s_aInstance = new EqualsUtils();

    private EqualsUtils() {
    }

    public static boolean equals(boolean aObj1, boolean aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(byte aObj1, byte aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(char aObj1, char aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(double aObj1, double aObj2) {
        return aObj1 == aObj2 || Double.doubleToLongBits(aObj1) == Double.doubleToLongBits(aObj2);
    }

    public static boolean equals(float aObj1, float aObj2) {
        return aObj1 == aObj2 || Float.floatToIntBits(aObj1) == Float.floatToIntBits(aObj2);
    }

    public static boolean equals(int aObj1, int aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(long aObj1, long aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(short aObj1, short aObj2) {
        return aObj1 == aObj2;
    }

    public static boolean equals(@Nullable Object aObj1, @Nullable Object aObj2) {
        return EqualsImplementationRegistry.areEqual(aObj1, aObj2);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static boolean nullSafeEqualsIgnoreCase(@Nullable String sObj1, @Nullable String sObj2) {
        return sObj1 == null ? sObj2 == null : sObj1.equalsIgnoreCase(sObj2);
    }
}

