/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.deadlock;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.deadlock.IThreadDeadlockListener;
import com.phloc.commons.deadlock.ThreadDeadlockDetectionTimer;
import com.phloc.commons.deadlock.ThreadDeadlockInfo;
import com.phloc.commons.state.EChange;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ThreadDeadlockDetector {
    private final ThreadMXBean m_aMBean = ManagementFactory.getThreadMXBean();
    private final Set<IThreadDeadlockListener> m_aListeners = new CopyOnWriteArraySet<IThreadDeadlockListener>();

    public void run() {
        long[] aThreadIDs;
        long[] lArray = aThreadIDs = this.m_aMBean.isSynchronizerUsageSupported() ? this.m_aMBean.findDeadlockedThreads() : this.m_aMBean.findMonitorDeadlockedThreads();
        if (!ArrayHelper.isEmpty(aThreadIDs)) {
            Map<Thread, StackTraceElement[]> aAllStackTraces = Thread.getAllStackTraces();
            ThreadDeadlockInfo[] aThreads = new ThreadDeadlockInfo[aThreadIDs.length];
            for (int i = 0; i < aThreads.length; ++i) {
                ThreadInfo aThreadInfo = this.m_aMBean.getThreadInfo(aThreadIDs[i]);
                Thread aFoundThread = null;
                StackTraceElement[] aFoundStackTrace = null;
                for (Map.Entry<Thread, StackTraceElement[]> aEnrty : aAllStackTraces.entrySet()) {
                    if (aEnrty.getKey().getId() != aThreadInfo.getThreadId()) continue;
                    aFoundThread = aEnrty.getKey();
                    aFoundStackTrace = aEnrty.getValue();
                    break;
                }
                if (aFoundThread == null) {
                    throw new IllegalStateException("Deadlocked Thread not found as defined by " + aThreadInfo.toString());
                }
                aThreads[i] = new ThreadDeadlockInfo(aThreadInfo, aFoundThread, aFoundStackTrace);
            }
            for (IThreadDeadlockListener aListener : this.m_aListeners) {
                aListener.onDeadlockDetected(aThreads);
            }
            if (this.m_aListeners.isEmpty()) {
                ThreadDeadlockDetectionTimer.s_aLogger.warn("Found a deadlock of " + aThreads.length + " threads but no listeners are present!");
            }
        }
    }

    @Nonnull
    public EChange addListener(@Nonnull IThreadDeadlockListener aListener) {
        if (aListener == null) {
            throw new NullPointerException("listener");
        }
        return EChange.valueOf(this.m_aListeners.add(aListener));
    }

    @Nonnull
    public EChange removeListener(@Nullable IThreadDeadlockListener aListener) {
        return EChange.valueOf(this.m_aListeners.remove(aListener));
    }

    @Nonnull
    public EChange removeAllListeners() {
        if (this.m_aListeners.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aListeners.clear();
        return EChange.CHANGED;
    }

    @Nonnegative
    public int getListenerCount() {
        return this.m_aListeners.size();
    }
}

