/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.crypto;

import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import java.security.InvalidKeyException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.ExemptionMechanism;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CryptoPolicy {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CryptoPolicy.class);
    private static AtomicBoolean s_aChecked = new AtomicBoolean(false);
    private static boolean s_bUnlimitedStrength;
    private static final CryptoPolicy s_aInstance;

    private CryptoPolicy() {
    }

    private static boolean _isUnlimitedStrengthAvailable() {
        try {
            KeyGenerator aKeyGen = KeyGenerator.getInstance("AES");
            aKeyGen.init(256);
            SecretKey aSecretKey = aKeyGen.generateKey();
            byte[] raw = aSecretKey.getEncoded();
            SecretKeySpec aSecretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher aCipher = Cipher.getInstance("AES/ECB/NoPadding");
            aCipher.init(1, aSecretKeySpec);
            byte[] aEncrypted = aCipher.doFinal(CharsetManager.getAsBytes("1234567890123456", CCharset.CHARSET_ISO_8859_1_OBJ));
            if (aEncrypted == null) {
                throw new IllegalStateException("Encryption of test string failed!");
            }
            ExemptionMechanism aExempt = aCipher.getExemptionMechanism();
            if (aExempt != null) {
                s_aLogger.info("Cipher uses exemption mechanism " + aExempt.getName());
                return false;
            }
        }
        catch (InvalidKeyException ex) {
            s_aLogger.info("Invalid key size - unlimited strength crypto NOT installed!");
            return false;
        }
        catch (Exception ex) {
            s_aLogger.info("Failed to determine unlimited strength crypto state", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean isUnlimitedStrengthCryptoAvailable() {
        if (!s_aChecked.get()) {
            s_bUnlimitedStrength = CryptoPolicy._isUnlimitedStrengthAvailable();
            s_aChecked.set(true);
        }
        return s_bUnlimitedStrength;
    }

    static {
        s_aInstance = new CryptoPolicy();
    }
}

