/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.convert.collections;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ArrayConversionHelper {
    private static final ArrayConversionHelper s_aInstance = new ArrayConversionHelper();

    private ArrayConversionHelper() {
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] getConverted(@Nonnull SRCTYPE[] aArray, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> aConv, @Nonnull Class<DSTTYPE> aDstClass) {
        DSTTYPE[] ret = ArrayHelper.newArray(aDstClass, aArray.length);
        for (int i = 0; i < aArray.length; ++i) {
            ret[i] = aConv.convert(aArray[i]);
        }
        return ret;
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nonnull Collection<? extends SRCTYPE> aList, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> aConv, @Nonnull Class<DSTTYPE> aDstClass) {
        if (aList == null) {
            throw new NullPointerException("list");
        }
        if (aConv == null) {
            throw new NullPointerException("converter");
        }
        DSTTYPE[] ret = ArrayHelper.newArray(aDstClass, aList.size());
        int i = 0;
        for (SRCTYPE aObj : aList) {
            ret[i++] = aConv.convert(aObj);
        }
        return ret;
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nullable SRCTYPE[] aArray, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> aConv, @Nonnull Class<DSTTYPE> aDstClass) {
        if (aConv == null) {
            throw new NullPointerException("converter");
        }
        DSTTYPE[] ret = ArrayHelper.newArray(aDstClass, ArrayHelper.getSize(aArray));
        if (aArray != null) {
            int i = 0;
            for (SRCTYPE aObj : aArray) {
                ret[i++] = aConv.convert(aObj);
            }
        }
        return ret;
    }
}

