/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.cache.AbstractNotifyingCache;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.system.SystemHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CollatorUtils {
    private static final CollatorCache s_aCache = new CollatorCache();
    private static final CollatorUtils s_aInstance = new CollatorUtils();

    private CollatorUtils() {
    }

    @Nonnull
    public static Collator getCollatorSpaceBeforeDot(@Nullable Locale aLocale) {
        Locale aRealLocale = aLocale == null ? SystemHelper.getSystemLocale() : aLocale;
        return (Collator)((Collator)s_aCache.getFromCache(aRealLocale)).clone();
    }

    @ThreadSafe
    private static final class CollatorCache
    extends AbstractNotifyingCache<Locale, Collator> {
        private static final Logger s_aLogger = LoggerFactory.getLogger(CollatorCache.class);

        public CollatorCache() {
            super(CollatorUtils.class.getName());
        }

        @Override
        @Nonnull
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        protected Collator getValueToCache(@Nullable Locale aLocale) {
            if (aLocale == null) {
                s_aLogger.error("Very weird: no locale passed in. Falling back to system locale.");
                return Collator.getInstance(SystemHelper.getSystemLocale());
            }
            Collator aCollator = Collator.getInstance(aLocale);
            if (aCollator == null) {
                s_aLogger.error("Failed to get Collator for Locale " + aLocale + " - using Collator for default locale!");
                return Collator.getInstance(SystemHelper.getSystemLocale());
            }
            if (!(aCollator instanceof RuleBasedCollator)) {
                s_aLogger.warn("Collator.getInstance did not return a RulleBasedCollator but a " + aCollator.getClass().getName());
                return aCollator;
            }
            try {
                String sRules = ((RuleBasedCollator)aCollator).getRules();
                if (sRules.indexOf("<'.'<") < 0) {
                    s_aLogger.warn("Failed to identify the Collator rule part to be replaced. Locale used: " + aLocale);
                    return aCollator;
                }
                String sNewRules = StringHelper.replaceAll(sRules, "<'.'<", "<' '<'.'<");
                RuleBasedCollator aNewCollator = new RuleBasedCollator(sNewRules);
                aNewCollator.setStrength(2);
                aNewCollator.setDecomposition(2);
                return aNewCollator;
            }
            catch (ParseException ex) {
                throw new IllegalStateException("Failed to parse collator rule set for locale " + aLocale, ex);
            }
        }
    }
}

