/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.pair;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ReadonlyIntPair {
    private final int m_aFirst;
    private final int m_aSecond;

    public ReadonlyIntPair(int aFirst, int aSecond) {
        this.m_aFirst = aFirst;
        this.m_aSecond = aSecond;
    }

    public ReadonlyIntPair(@Nonnull ReadonlyIntPair rhs) {
        this.m_aFirst = rhs.getFirst();
        this.m_aSecond = rhs.getSecond();
    }

    public int getFirst() {
        return this.m_aFirst;
    }

    public int getSecond() {
        return this.m_aSecond;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadonlyIntPair)) {
            return false;
        }
        ReadonlyIntPair rhs = (ReadonlyIntPair)o;
        return this.m_aFirst == rhs.m_aFirst && this.m_aSecond == rhs.m_aSecond;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).toString();
    }
}

