/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.SingleMapEntry;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleElementMap<KEYTYPE, VALUETYPE>
implements Map<KEYTYPE, VALUETYPE>,
IHasSize {
    private boolean m_bHasElement = false;
    private KEYTYPE m_aKey = null;
    private VALUETYPE m_aValue = null;

    public SingleElementMap() {
    }

    public SingleElementMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        this.put(aKey, aValue);
    }

    @Override
    public void clear() {
        this.m_bHasElement = false;
        this.m_aKey = null;
        this.m_aValue = null;
    }

    @Override
    public boolean containsKey(@Nullable Object aKey) {
        return this.m_bHasElement && EqualsUtils.equals(this.m_aKey, aKey);
    }

    @Override
    public boolean containsValue(@Nullable Object aValue) {
        return this.m_bHasElement && EqualsUtils.equals(this.m_aValue, aValue);
    }

    @Override
    @Nullable
    public VALUETYPE get(@Nullable Object aKey) {
        return this.containsKey(aKey) ? (VALUETYPE)this.m_aValue : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nullable
    public VALUETYPE put(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aElement) {
        VALUETYPE aOldElement = null;
        if (EqualsUtils.equals(aKey, this.m_aKey)) {
            aOldElement = this.m_aValue;
        } else {
            this.m_aKey = aKey;
        }
        this.m_aValue = aElement;
        this.m_bHasElement = true;
        return aOldElement;
    }

    @Override
    public void putAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        if (aMap != null && !aMap.isEmpty()) {
            if (aMap.size() != 1) {
                throw new IllegalArgumentException("Only maps with exactly one element are allowed!");
            }
            Map.Entry<KEYTYPE, VALUETYPE> aEntry = aMap.entrySet().iterator().next();
            this.put(aEntry.getKey(), aEntry.getValue());
        }
    }

    @Override
    @Nullable
    public VALUETYPE remove(@Nullable Object aKey) {
        if (!this.containsKey(aKey)) {
            return null;
        }
        VALUETYPE aOldElement = this.m_aValue;
        this.m_bHasElement = false;
        this.m_aValue = null;
        this.m_aKey = null;
        return aOldElement;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public Set<KEYTYPE> keySet() {
        return this.m_bHasElement ? ContainerHelper.newUnmodifiableSet(this.m_aKey) : Collections.emptySet();
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public Collection<VALUETYPE> values() {
        return this.m_bHasElement ? ContainerHelper.newUnmodifiableList(this.m_aValue) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<KEYTYPE, VALUETYPE>> entrySet() {
        HashSet<Map.Entry<KEYTYPE, VALUETYPE>> aSet = new HashSet<Map.Entry<KEYTYPE, VALUETYPE>>(this.size());
        if (this.m_bHasElement) {
            aSet.add(new SingleMapEntry<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue));
        }
        return aSet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleElementMap)) {
            return false;
        }
        SingleElementMap rhs = (SingleElementMap)o;
        return this.m_bHasElement == rhs.m_bHasElement && EqualsUtils.equals(this.m_aKey, rhs.m_aKey) && EqualsUtils.equals(this.m_aValue, rhs.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasElement).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasElement", this.m_bHasElement).append("key", this.m_aKey).append("value", this.m_aValue).toString();
    }
}

