/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache.convert;

import com.phloc.commons.cache.LoggingLRUCache;
import com.phloc.commons.cache.convert.SimpleCacheWithConversion;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleCacheWithConversionAndMaxSize<KEYTYPE, VALUETYPE>
extends SimpleCacheWithConversion<KEYTYPE, VALUETYPE> {
    private final int m_nMaxSize;

    public SimpleCacheWithConversionAndMaxSize(@Nonnull String sCacheName, @Nonnegative int nMaxSize) {
        super(sCacheName);
        if (nMaxSize <= 0) {
            throw new IllegalArgumentException("MaxSize must be > 0!");
        }
        this.m_nMaxSize = nMaxSize;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @Override
    @Nonnull
    protected final Map<KEYTYPE, VALUETYPE> createCache() {
        return new LoggingLRUCache(this.getName(), this.m_nMaxSize);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("maxSize", this.m_nMaxSize).toString();
    }
}

