/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.proxy;

import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.sorter.Comparable;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.proxy.AuthorizationRule;
import org.w3c.www.protocol.http.proxy.DirectRule;
import org.w3c.www.protocol.http.proxy.ForbidRule;
import org.w3c.www.protocol.http.proxy.ProxyAuthRule;
import org.w3c.www.protocol.http.proxy.ProxyRule;
import org.w3c.www.protocol.http.proxy.RedirectRule;
import org.w3c.www.protocol.http.proxy.RuleParserException;

public class Rule
implements Comparable {
    protected static String[] names = new String[]{"direct", "forbid", "proxy", "redirect", "authorization", "proxyauth"};
    String host = null;
    String args = null;
    String name = null;

    public String toString() {
        return this.host + " " + this.name;
    }

    public String getStringValue() {
        return this.toString();
    }

    public boolean greaterThan(Comparable comparable) {
        return this.getStringValue().compareTo(comparable.getStringValue()) > 0;
    }

    public void writeRule(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(this.toString() + "\n");
    }

    public String getHost() {
        return this.host;
    }

    public String getRuleName() {
        return this.name;
    }

    public String getRuleArgs() {
        return this.args;
    }

    protected void initialize(String[] stringArray, int n, int n2) throws RuleParserException {
        if (n != n2) {
            throw new RuleParserException("Unexpected token: " + stringArray[n]);
        }
        this.host = stringArray[0];
    }

    public static Rule createRule(String[] stringArray, int n, int n2) throws RuleParserException {
        Rule rule = null;
        if (stringArray == null || n2 - n == 0) {
            return null;
        }
        String string = stringArray[n];
        if (string.equalsIgnoreCase("direct")) {
            rule = new DirectRule();
        } else if (string.equalsIgnoreCase("proxy")) {
            rule = new ProxyRule();
        } else if (string.equalsIgnoreCase("forbid")) {
            rule = new ForbidRule();
        } else if (string.equalsIgnoreCase("redirect")) {
            rule = new RedirectRule();
        } else if (string.equalsIgnoreCase("authorization")) {
            rule = new AuthorizationRule();
        } else if (string.equalsIgnoreCase("proxyauth")) {
            rule = new ProxyAuthRule();
        } else {
            throw new RuleParserException("Unknown rule name \"" + string + "\"");
        }
        rule.initialize(stringArray, n + 1, n2);
        return rule;
    }

    public static String[] getRulesName() {
        return names;
    }

    public Reply apply(Request request) {
        return null;
    }
}

