/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.ParseState;

public class HttpRangeList
extends BasicValue {
    HttpRange[] ranges = null;

    protected void parse() {
        Vector<HttpRange> vector = new Vector<HttpRange>(2);
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            vector.addElement(new HttpRange(this, this.raw, parseState.start, parseState.end));
            parseState.prepare();
        }
        if (vector.size() > 0) {
            this.ranges = new HttpRange[vector.size()];
            vector.copyInto(this.ranges);
        }
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        for (int i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                httpBuffer.append(',');
            }
            this.ranges[i].appendValue(httpBuffer);
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public Object getValue() {
        this.validate();
        return this.ranges;
    }

    public void addRange(HttpRange httpRange) {
        if (this.ranges == null) {
            this.ranges = new HttpRange[1];
            this.ranges[0] = httpRange;
        } else {
            int n = this.ranges.length;
            HttpRange[] httpRangeArray = new HttpRange[n + 1];
            System.arraycopy(this.ranges, 0, httpRangeArray, 0, n);
            httpRangeArray[n] = httpRange;
            this.ranges = httpRangeArray;
        }
    }

    HttpRangeList(HttpRange[] httpRangeArray) {
        this.ranges = httpRangeArray;
        this.isValid = true;
    }

    HttpRangeList() {
        this.isValid = false;
    }
}

