/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.net.InetAddress;
import java.net.URL;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.RequestTimeout;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.timers.EventHandler;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeParserFactory;

public abstract class Client
implements EventHandler {
    private static final boolean debuglog = false;
    private static final byte[] hexaTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private Reply contreply = null;
    private MimeParserFactory factory = null;
    protected int identifier = -1;
    protected httpd server = null;
    protected boolean debug = false;
    protected byte[] buffer = null;
    private boolean running = false;
    private short major = (short)-1;
    private short minor = (short)-1;
    private InputStream input = null;
    private DataOutputStream output = null;
    private Object timer = null;
    private MimeParser parser = null;
    private boolean interrupted = false;
    protected int reqcount = 0;
    protected boolean cont = false;
    protected long prev_body_count = 0L;
    private boolean lenient = true;
    public URL currentURI = null;
    private boolean timedout;

    private synchronized void setTimeout(int n, Object object) {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
            this.timer = null;
        }
        this.timer = this.server.timer.registerTimer(n, this, object);
    }

    private synchronized void removeTimeout() {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
        }
    }

    public synchronized void handleTimerEvent(Object object, long l) {
        this.timer = null;
        Reply reply = new Reply(this);
        reply.setStatus(408);
        this.interruptConnection(true);
    }

    private synchronized void terminate() {
        if (!this.running) {
            return;
        }
        this.removeTimeout();
        try {
            if (this.output != null) {
                this.output.flush();
                this.output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.input = null;
        this.output = null;
        this.parser = null;
        this.major = (short)-1;
        this.minor = (short)-1;
        this.interrupted = false;
        this.running = false;
    }

    protected boolean tryKeepConnection(Request request, Reply reply) {
        if (!this.server.getClientKeepConnection()) {
            return false;
        }
        if (!request.canKeepConnection()) {
            if (reply.tryKeepConnection()) {
                reply.addConnection("close");
            }
            return false;
        }
        return reply.tryKeepConnection();
    }

    protected Request getNextRequest() throws ClientException, IOException {
        Request request = null;
        this.cont = false;
        this.timedout = false;
        try {
            request = (Request)this.parser.parse(this.lenient);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.timedout = true;
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HttpParserException httpParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                httpParserException.printStackTrace();
            }
            throw new ClientException(this, httpParserException);
        }
        catch (MimeParserException mimeParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                mimeParserException.printStackTrace();
            }
            throw new ClientException(this, mimeParserException);
        }
        if (this.debug) {
            request.dump(System.out);
        }
        return request;
    }

    /*
     * Exception decompiling
     */
    protected int chunkTransfer(InputStream var1_1, Reply var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int emitReply(Reply reply) throws IOException {
        boolean bl = false;
        if (reply.getStatus() == 1001) {
            return -1;
        }
        InputStream inputStream = reply.openStream();
        if (inputStream == null) {
            if (this.debug) {
                reply.dump(System.out);
            }
            reply.emit(this.output);
            return -1;
        }
        bl = reply.canChunkTransfer();
        if (this.debug) {
            reply.dump(System.out);
        }
        if (reply.getStatus() != 1000) {
            reply.emit(this.output);
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.getServer().getClientBufferSize()];
        }
        int n = 0;
        try {
            if (bl) {
                n = this.chunkTransfer(inputStream, reply);
                return n;
            }
            int n2 = 0;
            while (n2 >= 0) {
                this.output.write(this.buffer, 0, n2);
                n += n2;
                try {
                    n2 = inputStream.read(this.buffer, 0, this.buffer.length);
                }
                catch (IOException iOException) {
                    if (!reply.hasState("org.w3c.jigsaw.servlet.runner")) throw iOException;
                    if (!(inputStream instanceof PipedInputStream)) throw iOException;
                    if (reply.hasState("org.w3c.jigsaw.servlet.ended")) throw iOException;
                    n2 = 0;
                }
            }
            return n;
        }
        finally {
            inputStream.close();
        }
    }

    protected Reply processRequest(Request request) throws ClientException {
        Reply reply = null;
        this.setTimeout(this.server.getRequestTimeOut(), new RequestTimeout(this));
        try {
            reply = (Reply)this.server.perform(request);
        }
        catch (ProtocolException protocolException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                protocolException.printStackTrace();
            }
            if (reply != null && reply.hasStream()) {
                try {
                    reply.openStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (protocolException.hasReply()) {
                return (Reply)protocolException.getReply();
            }
            throw new ClientException(this, protocolException);
        }
        catch (ResourceException resourceException) {
            throw new ClientException(this, resourceException);
        }
        if (reply == null) {
            String string = "target resource emited a null Reply.";
            throw new ClientException(this, string);
        }
        ++this.reqcount;
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean startConnection(InputStream inputStream, DataOutputStream dataOutputStream) throws ClientException {
        block120: {
            Object object4222;
            boolean bl = true;
            long l = 0L;
            long l2 = 0L;
            HttpEntityMessage httpEntityMessage = null;
            Reply reply = null;
            int n = 0;
            int n2 = 0;
            ClientException clientException = null;
            this.input = inputStream;
            this.output = dataOutputStream;
            this.parser = new MimeParser(this.input, this.factory);
            try {
                this.running = true;
                block50: while (!this.interrupted && bl) {
                    Object object2;
                    try {
                        if (this.prev_body_count > 0L) {
                            this.input.mark(2048);
                        }
                        if (n2 == 0) {
                            httpEntityMessage = this.getNextRequest();
                            if (httpEntityMessage == null) break;
                            this.major = httpEntityMessage.getMajorVersion();
                            this.minor = httpEntityMessage.getMinorVersion();
                        } else {
                            this.interrupted = this.idleConnection();
                            if (this.interrupted) break;
                            while ((httpEntityMessage = this.getNextRequest()) == null) {
                                if (!this.timedout) break block50;
                            }
                            this.major = httpEntityMessage.getMajorVersion();
                            this.minor = httpEntityMessage.getMinorVersion();
                            this.usedConnection();
                        }
                    }
                    catch (ClientException clientException2) {
                        if (clientException2.ex != null && clientException2.ex instanceof HttpParserException) {
                            object2 = (HttpParserException)clientException2.ex;
                            if (!((HttpParserException)object2).hasRequest()) {
                                throw clientException2;
                            }
                            httpEntityMessage = (Request)((HttpParserException)object2).getRequest();
                            if (n2 == 0) {
                                this.major = httpEntityMessage.getMajorVersion();
                                this.minor = httpEntityMessage.getMinorVersion();
                            }
                            this.usedConnection();
                            reply = (Reply)((Request)httpEntityMessage).makeBadRequestReply();
                            reply.setContentLength(0);
                            reply.addConnection("close");
                            bl = false;
                            n = this.emitReply(reply);
                            this.log((Request)httpEntityMessage, reply, 0, 0L);
                            ++n2;
                            ++this.reqcount;
                            break;
                        }
                        if (clientException2.ex != null && clientException2.ex instanceof MimeParserException) {
                            reply = new Reply(this);
                            reply.setStatus(400);
                            reply.setContentLength(0);
                            reply.addConnection("close");
                            bl = false;
                            n = this.emitReply(reply);
                            this.log((Request)httpEntityMessage, reply, 0, 0L);
                            ++n2;
                            ++this.reqcount;
                            break;
                        }
                        throw clientException2;
                    }
                    catch (Exception exception) {
                        if (this.debug) {
                            exception.printStackTrace();
                        }
                        if (exception.getMessage().startsWith("Bad request") && this.prev_body_count > 0L) {
                            this.usedConnection();
                            if (this.debug) {
                                System.out.println("Error after a body request! (Skipping: " + this.prev_body_count + " bytes)");
                            }
                            this.input.reset();
                            object2 = new byte[(int)this.prev_body_count];
                            this.prev_body_count -= (long)this.input.read((byte[])object2);
                            this.prev_body_count -= this.input.skip(this.prev_body_count);
                            break;
                        }
                        throw exception;
                    }
                    this.currentURI = ((HttpRequestMessage)httpEntityMessage).getURL();
                    l = System.currentTimeMillis();
                    reply = this.processRequest((Request)httpEntityMessage);
                    l2 = System.currentTimeMillis();
                    this.currentURI = null;
                    if (bl) {
                        bl = this.tryKeepConnection((Request)httpEntityMessage, reply);
                    }
                    n = this.emitReply(reply);
                    if (reply.hasContentLength() && n >= 0 && reply.getContentLength() != n) {
                        bl = false;
                    }
                    this.prev_body_count = httpEntityMessage.getContentLength();
                    this.log((Request)httpEntityMessage, reply, n, l2 - l);
                    ++n2;
                    if (bl) {
                        this.output.flush();
                    }
                    if (reply.getStatus() == 101) {
                        this.input = null;
                        this.output = null;
                        throw new Exception("Switching");
                    }
                    if (!httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) continue;
                    try {
                        PipedInputStream pipedInputStream = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                        pipedInputStream.close();
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (IOException iOException) {}
                }
                Object var16_25 = null;
                this.currentURI = null;
            }
            catch (Throwable throwable) {
                Object object32222;
                Object var16_30 = null;
                this.currentURI = null;
                if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                    try {
                        object32222 = ((Request)httpEntityMessage).getInputStream();
                        if (object32222 != null) {
                            while (((InputStream)object32222).available() > 0) {
                                ((InputStream)object32222).read(this.buffer, 0, this.buffer.length);
                            }
                        }
                    }
                    catch (Exception object32222) {
                        // empty catch block
                    }
                }
                if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                    try {
                        object32222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                        ((PipedInputStream)object32222).close();
                    }
                    catch (ClassCastException object32222) {
                    }
                    catch (IOException object32222) {
                    }
                    catch (Exception object32222) {
                        // empty catch block
                    }
                }
                this.terminate();
                if (reply == null || reply.getStatus() != 101) {
                    this.stopConnection();
                    if (reply != null) {
                        try {
                            reply.openStream().close();
                        }
                        catch (Exception object32222) {
                            // empty catch block
                        }
                    }
                }
                if (clientException != null) {
                    throw clientException;
                }
                throw throwable;
            }
            if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                try {
                    object4222 = ((Request)httpEntityMessage).getInputStream();
                    if (object4222 != null) {
                        while (((InputStream)object4222).available() > 0) {
                            ((InputStream)object4222).read(this.buffer, 0, this.buffer.length);
                        }
                    }
                }
                catch (Exception object4222) {
                    // empty catch block
                }
            }
            if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                try {
                    object4222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                    ((PipedInputStream)object4222).close();
                }
                catch (ClassCastException object4222) {
                }
                catch (IOException object4222) {
                }
                catch (Exception object4222) {
                    // empty catch block
                }
            }
            this.terminate();
            if (reply == null || reply.getStatus() != 101) {
                this.stopConnection();
                if (reply != null) {
                    try {
                        reply.openStream().close();
                    }
                    catch (Exception object4222) {
                        // empty catch block
                    }
                }
            }
            if (clientException != null) {
                throw clientException;
            }
            break block120;
            {
                catch (IOException iOException) {
                    Object object52222;
                    if (this.debug) {
                        System.out.println("+++ " + this + " got IOException:");
                        iOException.printStackTrace();
                    }
                    try {
                        InputStream inputStream2 = null;
                        if (reply != null && (inputStream2 = reply.openStream()) != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    clientException = new ClientException(this, iOException);
                    Object var16_26 = null;
                    this.currentURI = null;
                    if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                        try {
                            object52222 = ((Request)httpEntityMessage).getInputStream();
                            if (object52222 != null) {
                                while (((InputStream)object52222).available() > 0) {
                                    ((InputStream)object52222).read(this.buffer, 0, this.buffer.length);
                                }
                            }
                        }
                        catch (Exception object52222) {
                            // empty catch block
                        }
                    }
                    if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                        try {
                            object52222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                            ((PipedInputStream)object52222).close();
                        }
                        catch (ClassCastException object52222) {
                        }
                        catch (IOException object52222) {
                        }
                        catch (Exception object52222) {
                            // empty catch block
                        }
                    }
                    this.terminate();
                    if (reply == null || reply.getStatus() != 101) {
                        this.stopConnection();
                        if (reply != null) {
                            try {
                                reply.openStream().close();
                            }
                            catch (Exception object52222) {
                                // empty catch block
                            }
                        }
                    }
                    if (clientException != null) {
                        throw clientException;
                    }
                    break block120;
                }
                catch (ClientException clientException3) {
                    Object object62222;
                    if (this.debug) {
                        System.out.println("+++ " + this + " got ClientException:");
                        clientException3.printStackTrace();
                    }
                    try {
                        InputStream inputStream3 = null;
                        if (reply != null && (inputStream3 = reply.openStream()) != null) {
                            inputStream3.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    clientException = clientException3;
                    Object var16_27 = null;
                    this.currentURI = null;
                    if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                        try {
                            object62222 = ((Request)httpEntityMessage).getInputStream();
                            if (object62222 != null) {
                                while (((InputStream)object62222).available() > 0) {
                                    ((InputStream)object62222).read(this.buffer, 0, this.buffer.length);
                                }
                            }
                        }
                        catch (Exception object62222) {
                            // empty catch block
                        }
                    }
                    if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                        try {
                            object62222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                            ((PipedInputStream)object62222).close();
                        }
                        catch (ClassCastException object62222) {
                        }
                        catch (IOException object62222) {
                        }
                        catch (Exception object62222) {
                            // empty catch block
                        }
                    }
                    this.terminate();
                    if (reply == null || reply.getStatus() != 101) {
                        this.stopConnection();
                        if (reply != null) {
                            try {
                                reply.openStream().close();
                            }
                            catch (Exception object62222) {
                                // empty catch block
                            }
                        }
                    }
                    if (clientException != null) {
                        throw clientException;
                    }
                    break block120;
                }
                catch (NullPointerException nullPointerException) {
                    Object object72222;
                    if (this.debug) {
                        System.out.println("+++ " + this + " got exception:");
                        nullPointerException.printStackTrace();
                    }
                    clientException = this.currentURI != null ? new ClientException(this, nullPointerException, this.currentURI.toString()) : new ClientException(this, nullPointerException);
                    Object var16_28 = null;
                    this.currentURI = null;
                    if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                        try {
                            object72222 = ((Request)httpEntityMessage).getInputStream();
                            if (object72222 != null) {
                                while (((InputStream)object72222).available() > 0) {
                                    ((InputStream)object72222).read(this.buffer, 0, this.buffer.length);
                                }
                            }
                        }
                        catch (Exception object72222) {
                            // empty catch block
                        }
                    }
                    if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                        try {
                            object72222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                            ((PipedInputStream)object72222).close();
                        }
                        catch (ClassCastException object72222) {
                        }
                        catch (IOException object72222) {
                        }
                        catch (Exception object72222) {
                            // empty catch block
                        }
                    }
                    this.terminate();
                    if (reply == null || reply.getStatus() != 101) {
                        this.stopConnection();
                        if (reply != null) {
                            try {
                                reply.openStream().close();
                            }
                            catch (Exception object72222) {
                                // empty catch block
                            }
                        }
                    }
                    if (clientException != null) {
                        throw clientException;
                    }
                    break block120;
                }
                catch (Exception exception) {
                    Object object82222;
                    if (this.debug) {
                        System.out.println("+++ " + this + " got exception:");
                        exception.printStackTrace();
                    }
                    clientException = new ClientException(this, exception);
                    Object var16_29 = null;
                    this.currentURI = null;
                    if (clientException == null && httpEntityMessage != null && httpEntityMessage.getContentLength() > 0 && reply != null && reply.getStatus() != 101 && reply.getStatus() / 100 != 2) {
                        try {
                            object82222 = ((Request)httpEntityMessage).getInputStream();
                            if (object82222 != null) {
                                while (((InputStream)object82222).available() > 0) {
                                    ((InputStream)object82222).read(this.buffer, 0, this.buffer.length);
                                }
                            }
                        }
                        catch (Exception object82222) {
                            // empty catch block
                        }
                    }
                    if (httpEntityMessage != null && httpEntityMessage.hasState("org.w3c.jigsaw.servlet.stream")) {
                        try {
                            object82222 = (PipedInputStream)httpEntityMessage.getState("org.w3c.jigsaw.servlet.stream");
                            ((PipedInputStream)object82222).close();
                        }
                        catch (ClassCastException object82222) {
                        }
                        catch (IOException object82222) {
                        }
                        catch (Exception object82222) {
                            // empty catch block
                        }
                    }
                    this.terminate();
                    if (reply == null || reply.getStatus() != 101) {
                        this.stopConnection();
                        if (reply != null) {
                            try {
                                reply.openStream().close();
                            }
                            catch (Exception object82222) {
                                // empty catch block
                            }
                        }
                    }
                    if (clientException != null) {
                        throw clientException;
                    }
                }
            }
        }
        return this.interrupted;
    }

    protected synchronized void interruptConnection(boolean bl) {
        if (this.running) {
            this.interrupted = true;
            if (bl) {
                this.terminate();
            }
        }
    }

    public int sendContinue() throws IOException {
        if (this.cont) {
            return -1;
        }
        if (this.major > 1 || this.major == 1 && this.minor >= 1) {
            if (this.contreply == null) {
                this.contreply = new Reply(this, null, this.major, this.minor, 100);
            }
            int n = this.emitReply(this.contreply);
            this.output.flush();
            this.cont = true;
            return n;
        }
        return -1;
    }

    public int sendContinue(Reply reply) throws IOException {
        if (reply == null) {
            return this.sendContinue();
        }
        if (this.major > 1 || this.major == 1 && this.minor >= 1) {
            int n = this.emitReply(reply);
            this.output.flush();
            this.cont = true;
            return n;
        }
        return -1;
    }

    public final int getIdentifier() {
        return this.identifier;
    }

    public final synchronized boolean isRunning() {
        return this.running;
    }

    public final short getMajorVersion() {
        return this.major;
    }

    public final short getMinorVersion() {
        return this.minor;
    }

    public final boolean isInterrupted() {
        return this.interrupted;
    }

    public final int getRequestCount() {
        return this.reqcount;
    }

    public final httpd getServer() {
        return this.server;
    }

    public final void error(String string) {
        this.server.errlog(this, string);
    }

    public final void trace(String string) {
        this.server.trace(this, string);
    }

    public void log(Request request, Reply reply, int n, long l) {
        this.server.log(this, request, reply, n, l);
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public abstract InetAddress getInetAddress();

    protected abstract boolean idleConnection();

    protected abstract void usedConnection();

    protected abstract void stopConnection();

    protected abstract Thread getThread();

    protected void initialize(httpd httpd2, int n) {
        this.server = httpd2;
        this.lenient = httpd2.isLenient();
        this.identifier = n;
        this.debug = httpd2.getClientDebug();
        this.factory = httpd2.getMimeClientFactory(this);
    }
}

