/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.jigsaw.filters.SimpleCache;
import org.w3c.jigsaw.filters.SimpleCacheException;
import org.w3c.jigsaw.filters.SimpleCacheFilter;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.LRUNode;

final class SimpleCacheEntry
extends LRUNode {
    SimpleCacheFilter filter;
    private String url;
    private byte[] replyText;
    protected long date;

    public String toString() {
        return "[\"" + this.url + "\"]";
    }

    public final String getURL() {
        return this.url;
    }

    SimpleCacheEntry(Request request, Reply reply, SimpleCacheFilter simpleCacheFilter) throws SimpleCacheException {
        this.url = SimpleCache.getNormalizedURL(request);
        this.filter = simpleCacheFilter;
        try {
            this.readReply(reply);
        }
        catch (IOException iOException) {
            throw new SimpleCacheException("cannot read reply content");
        }
        this.date = System.currentTimeMillis();
        this.date -= this.date % 1000L;
    }

    boolean isFresh() {
        int n = (int)((System.currentTimeMillis() - this.date) / 1000L);
        return n < this.filter.getDefaultMaxAge();
    }

    public final int getSize() {
        return this.replyText.length;
    }

    private void readReply(Reply reply) throws IOException {
        int n = -1;
        n = reply.hasContentLength() ? reply.getContentLength() + 500 : 8192;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        reply.dump(byteArrayOutputStream);
        byteArrayOutputStream.close();
        this.replyText = byteArrayOutputStream.toByteArray();
        reply.setStatus(1000);
        reply.setStream(new ByteArrayInputStream(this.replyText));
    }

    public final void dump(OutputStream outputStream) throws IOException {
        outputStream.write(this.replyText);
    }
}

